<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 17:25:23
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 * @method getStoreStaffsByParams(array $params) 获取门店伙伴列表
 * @method cancelHangByParams(array $params) 取消挂起
 * @method getStaffStatusByParams(array $params) 获取伙伴的状态
 * @method getNamesByStaffIdsByParams(array $params) 通过staffIds获取伙伴名字列表
 * @method getProcessingTimesByParams(array $params) 门店工作信息
 * @method getStaffInfoByIdByParams(array $params) 根据伙伴ID获取伙伴信息
 * @method getProductCatAllByParams(array $params) 获取产品树
 * @method showStaffProductsByParams(array $params) 获取员工通关产品数据
 */
class Staff {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Paperless\\Staff";

    /**
     * 获取门店伙伴列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreStaffs();
    }
    /**
     * 取消挂起
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function cancelHang (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang($_params);
    }
    /**
     * 获取伙伴的状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffStatus (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffStatus($_params);
    }
    /**
     * 通过staffIds获取伙伴名字列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getNamesByStaffIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNamesByStaffIds($_params);
    }
    /**
     * 门店工作信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getProcessingTimes () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProcessingTimes();
    }
    /**
     * 根据伙伴ID获取伙伴信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffInfoById (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoById($_params);
    }
    /**
     * 获取产品树
     * @return  array
    */
    public static function getProductCatAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCatAll();
    }
    /**
     * 获取员工通关产品数据
     * @return  mixed
    */
    public static function showStaffProducts (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->showStaffProducts(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}