<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-19 10:32:11
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PictureOnlineV2
 * @method stageStatisticsByParams(array $params) 在线看片列表统计
 * @method stageListByParams(array $params) 在线看片列表
 * @method detailByParams(array $params) 在线看片详情
 * @method changeQueueIndexByParams(array $params) 修改排队位置
 * @method pictureOnlineWatcherListByParams(array $params) 获取注册云端在线看片师列表
 * @method assignStorePictureOnlineWatcherByParams(array $params) 指派门店在线看片师
 * @method checkWatchPictureOrderReenterQueueStateByParams(array $params) 获取在线看片单回退状态
 * @method watchPictureOrderReenterQueueByParams(array $params) 在线看片单退回队列
 * @method waitLookPhotoQueueMaxIndexByParams(array $params) 获取当前门店看片队列最大等待数
 * @method watchOrderInfoByParams(array $params) 在线看片详情
 * @method pictureOnlineWatcherStateByParams(array $params) 当前看片单看片师工作状态
 * @method afterSaleMessageUnderByParams(array $params) 获取售后单未读消息数
 * @method afterSaleMessageReadAllByParams(array $params) 售后单消息全读
 */
class PictureOnlineV2 {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\PictureOnlineV2";

    /**
     * 在线看片列表统计
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\StageStatisticsDTO
    */
    public static function stageStatistics (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\StatisticsCmd $statisticsCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stageStatistics($statisticsCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\StageStatisticsDTO"
        );
    }
    /**
     * 在线看片列表
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\ListPageDTO
    */
    public static function stageList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\PictureOnlineListCmd $pictureOnlineListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stageList($pictureOnlineListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\ListPageDTO"
        );
    }
    /**
     * 在线看片详情
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\DetailDTO
    */
    public static function detail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\DetailCmd $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail($detailCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\DetailDTO"
        );
    }
    /**
     * 修改排队位置
     * @return  bool
    */
    public static function changeQueueIndex (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\ChangeQueueIndexCmd $changeQueueIndexCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeQueueIndex($changeQueueIndexCmd);
    }
    /**
     * 获取注册云端在线看片师列表
     * @return  array
    */
    public static function pictureOnlineWatcherList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\PictureOnlineWatcherListCmd $pictureOnlineWatcherListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pictureOnlineWatcherList($pictureOnlineWatcherListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\WatcherListDTO[]"
        );
    }
    /**
     * 指派门店在线看片师
     * @return  bool
    */
    public static function assignStorePictureOnlineWatcher (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\AssignPictureOnlineWatcherCmd $assignPictureOnlineWatcherCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignStorePictureOnlineWatcher($assignPictureOnlineWatcherCmd);
    }
    /**
     * 获取在线看片单回退状态
     * @return  array
    */
    public static function checkWatchPictureOrderReenterQueueState (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\DetailCmd $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkWatchPictureOrderReenterQueueState($detailCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\ReenterQueueStateDTO[]"
        );
    }
    /**
     * 在线看片单退回队列
     * @return  int
    */
    public static function watchPictureOrderReenterQueue (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\ReenterQueueCmd $reenterQueueCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->watchPictureOrderReenterQueue($reenterQueueCmd);
    }
    /**
     * 获取当前门店看片队列最大等待数
     * @return  int
    */
    public static function waitLookPhotoQueueMaxIndex (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Common\SessionCmd $sessionCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->waitLookPhotoQueueMaxIndex($sessionCmd);
    }
    /**
     * 在线看片详情
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\WatchOrderInfoDTO
    */
    public static function watchOrderInfo (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnlineV2\DetailCmd $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->watchOrderInfo($detailCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\WatchOrderInfoDTO"
        );
    }
    /**
     * 当前看片单看片师工作状态
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\PictureOnlineWatcherStateDTO
    */
    public static function pictureOnlineWatcherState (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pictureOnlineWatcherState(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnlineV2\PictureOnlineWatcherStateDTO"
        );
    }
    /**
     * 获取售后单未读消息数
     * @return  bool
    */
    public static function afterSaleMessageUnder (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StaffIdCmd $staffIdCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSaleMessageUnder($staffIdCmd);
    }
    /**
     * 售后单消息全读
     * @return  bool
    */
    public static function afterSaleMessageReadAll (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StaffIdCmd $staffIdCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSaleMessageReadAll($staffIdCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}