<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-19 10:32:11
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class LookingPhoto
 * @method submitFinalPhotoByParams(array $params) 提交最终成片
 * @method clearAutoFinishPhotoByParams(array $params) 清除自动看片完成订单的顾客满意片
 * @method sendNoticeByParams(array $params) 发送授权确认推送
 * @method backWaitLookingByParams(array $params) 订单退回等待看片
 * @method backWaitLookPhotoByParams(array $params) 退回至看片排队中
 * @method kpsOrderAgainByParams(array $params) 看片师再来一单
 * @method kpSignInByParams(array $params) 看片签到
 * @method kpsBeginWorkByParams(array $params) 看片师开始工作
 * @method kpsEndWorkByParams(array $params) 看片师结束工作
 * @method getOrderOnlineByParams(array $params) 看片师已接订单
 * @method getHistoryListByParams(array $params) 获取看片师历史上传记录列表
 */
class LookingPhoto {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\LookingPhoto";

    /**
     * 提交最终成片
     * @return  bool
    */
    public static function submitFinalPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\SubmitFinalPhotoCmd $submitFinalPhotoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhoto($submitFinalPhotoCmd);
    }
    /**
     * 清除自动看片完成订单的顾客满意片
     * @return  bool
    */
    public static function clearAutoFinishPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearAutoFinishPhoto(["orderId" => $orderId]);
    }
    /**
     * 发送授权确认推送
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendNotice (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNotice($_params);
    }
    /**
     * 订单退回等待看片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function backWaitLooking (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitLooking($_params);
    }
    /**
     * 退回至看片排队中
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function backWaitLookPhoto (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitLookPhoto($_params);
    }
    /**
     * 看片师再来一单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function kpsOrderAgain () {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpsOrderAgain();
    }
    /**
     * 看片签到
     * @return  bool
    */
    public static function kpSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $retouchSignInCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpSignIn($retouchSignInCmd);
    }
    /**
     * 看片师开始工作
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function kpsBeginWork () {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpsBeginWork();
    }
    /**
     * 看片师结束工作
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function kpsEndWork () {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpsEndWork();
    }
    /**
     * 看片师已接订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getOrderOnline () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderOnline(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\LookingPhoto\OrderOnlineDTO[]"
        );
    }
    /**
     * 获取看片师历史上传记录列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getHistoryList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryList($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}