<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-10 17:13:10
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UploadRecord
 * @method searchOrderByParams(array $params) 摄影师中心：搜索订单
 * @method uploadListByParams(array $params) 上传记录列表
 * @method tabRefundNotDealWithByParams(array $params) 标记退款中不需要处理
 * @method tabOrderUpdateNotDealWithByParams(array $params) 标记订单无需处理
 * @method variousUploadedTotalByParams(array $params) 获取各上传总数
 * @method uploadPhotoCloudByParams(array $params) 上传照片到云端
 * @method uploadPhotoCloudAsyncByParams(array $params) 异步上传照片到云端
 * @method uploadPhotoCloudAsyncV3ByParams(array $params) 异步上传照片到云端V3
 * @method hookUploadPhotoByParams(array $params) hook照片上传
 * @method getOrderProductUploadedNumByParams(array $params) 获取订单剩余可传张数
 * @method needReUploadReasonByParams(array $params) 是否需要填写重传原因
 */
class UploadRecord {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\UploadRecord";

    /**
     * 摄影师中心：搜索订单
     * @return  array
    */
    public static function searchOrder (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $searchOrderCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchOrder($searchOrderCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\SearchOrderDTO[]"
        );
    }
    /**
     * 上传记录列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function uploadList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadList($_params);
    }
    /**
     * 标记退款中不需要处理
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function tabRefundNotDealWith (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tabRefundNotDealWith($_params);
    }
    /**
     * 标记订单无需处理
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function tabOrderUpdateNotDealWith (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tabOrderUpdateNotDealWith($_params);
    }
    /**
     * 获取各上传总数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function variousUploadedTotal (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->variousUploadedTotal($_params);
    }
    /**
     * 上传照片到云端
     * @return  int
    */
    public static function uploadPhotoCloud (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $uploadPhotoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadPhotoCloud($uploadPhotoCmd);
    }
    /**
     * 异步上传照片到云端
     * @return  int
    */
    public static function uploadPhotoCloudAsync (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoAsyncCmd $uploadPhotoAsyncCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadPhotoCloudAsync($uploadPhotoAsyncCmd);
    }
    /**
     * 异步上传照片到云端V3
     * @return  int
    */
    public static function uploadPhotoCloudAsyncV3 (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoAsyncV3Cmd $uploadPhotoAsyncV3Cmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadPhotoCloudAsyncV3($uploadPhotoAsyncV3Cmd);
    }
    /**
     * hook照片上传
     * @return  bool
    */
    public static function hookUploadPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\PhotoInfoCmd $photoInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUploadPhoto($photoInfoCmd);
    }
    /**
     * 获取订单剩余可传张数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\OrderProductUploadedNumDTO
    */
    public static function getOrderProductUploadedNum (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderProductUploadedNum($_params),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\OrderProductUploadedNumDTO"
        );
    }
    /**
     * 是否需要填写重传原因
     * @return  bool
    */
    public static function needReUploadReason (int $orderId, int $cloudStreamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->needReUploadReason(["orderId" => $orderId, "cloudStreamId" => $cloudStreamId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}