<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-02 15:10:21
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Service\WorkingTask;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Process
 * @method changeAreaByParams(array $params) 更新流程登记地
 * @method photoSizeByParams(array $params) 获取流程登记地
 * @method technologyDetailByParams(array $params) 获取产品的技术要点
 * @method updateTechnologyPointByParams(array $params) 更新技术要点
 * @method saveNoteByParams(array $params) 保存化妆备注
 * @method photoSizeTypeSettingByParams(array $params) photoSizeTypeSetting
 */
class Process {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Service\\WorkingTask\\Process";

    /**
     * 更新流程登记地
     * @return  bool
    */
    public static function changeArea (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\Process\ChangeAreaCmd $changeAreaCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeArea($changeAreaCmd);
    }
    /**
     * 获取流程登记地
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\Process\PhotoSizeDTO
    */
    public static function photoSize (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\Process\PhotoSizeCmd $photoSizeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoSize($photoSizeCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\Process\PhotoSizeDTO"
        );
    }
    /**
     * 获取产品的技术要点
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function technologyDetail (int $productId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->technologyDetail(array_merge($_params, ["productId" => $productId])),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDetailDTO[]"
        );
    }
    /**
     * 更新技术要点
     * @return  bool
    */
    public static function updateTechnologyPoint (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\Process\UpdateTechnicalPointCmd $updateTechnicalPointCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTechnologyPoint($updateTechnicalPointCmd);
    }
    /**
     * 保存化妆备注
     * @return  bool
    */
    public static function saveNote (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\Process\SaveNoteCmd $saveNoteCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote($saveNoteCmd);
    }
    /**
     * photoSizeTypeSetting
     * @return  array
    */
    public static function photoSizeTypeSetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->photoSizeTypeSetting();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}