<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 16:11:07
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\SelectPhotoWorkbench;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Workbench
 * @method allStoresByParams(array $params) 获取全国所有门店
 * @method storeListByParams(array $params) 获取可选的门店列表(含兼岗)
 * @method cameramanListByParams(array $params) 获取门店摄影师列表(含兼岗)
 * @method selectStoreByParams(array $params) 切换门店
 * @method getCurrentStoreInfoByParams(array $params) 获取当前门店信息
 * @method getCP1VersionsZipByParams(array $params) 获取cp1各版本初始化文件
 * @method getRepairPhotoTagListByParams(array $params) 获取修图备注标签列表
 * @method reportNasProblemByParams(array $params) nas问题上报
 */
class Workbench {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "SelectPhotoWorkbench\\Workbench";

    /**
     * 获取全国所有门店
     * @return  array
    */
    public static function allStores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allStores(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取可选的门店列表(含兼岗)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function storeList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeList(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取门店摄影师列表(含兼岗)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function cameramanList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cameramanList(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StaffDTO[]"
        );
    }
    /**
     * 切换门店
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function selectStore (int $storeId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectStore(array_merge($_params, ["storeId" => $storeId]));
    }
    /**
     * 获取当前门店信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCurrentStoreInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentStoreInfo();
    }
    /**
     * 获取cp1各版本初始化文件
     * @return  array
    */
    public static function getCP1VersionsZip () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCP1VersionsZip();
    }
    /**
     * 获取修图备注标签列表
     * @return  array
    */
    public static function getRepairPhotoTagList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRepairPhotoTagList();
    }
    /**
     * nas问题上报
     * @return  bool
    */
    public static function reportNasProblem (\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\Cmd\ReportNasProblemCmd $reportNasProblemCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportNasProblem($reportNasProblemCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}