<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 16:11:07
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PictureOnline
 * @method batchCheckConformOnlineOrderByParams(array $params) 批量获取订单是否符合在线看片
 * @method checkConformOnlineOrderByParams(array $params) 订单是否符合在线看片
 * @method listByParams(array $params) 已打印和已邮寄列表
 * @method migrationPictureOnlinePhpToJavaByParams(array $params)  php 在线看片单迁移至 java
 */
class PictureOnline {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Api\\PictureOnline";

    /**
     * 批量获取订单是否符合在线看片
     * @return  array
    */
    public static function batchCheckConformOnlineOrder (array $orderInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCheckConformOnlineOrder(["orderInfo" => $orderInfo]);
    }
    /**
     * 订单是否符合在线看片
     * @return  bool
    */
    public static function checkConformOnlineOrder (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkConformOnlineOrder(["orderNo" => $orderNo]);
    }
    /**
     * 已打印和已邮寄列表
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\PictureOnline\ListDTO
    */
    public static function list (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\PictureOnline\ListDTO"
        );
    }
    /**
     *  php 在线看片单迁移至 java
     * @return  mixed
    */
    public static function migrationPictureOnlinePhpToJava (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\CreatePictureOnlineFromPhpToJavaCmd $createPictureOnlineFromPhpToJavaCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->migrationPictureOnlinePhpToJava($createPictureOnlineFromPhpToJavaCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}