<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 18:04:13
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\SelectPhotoWorkbench;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 * @method orderListByParams(array $params) 选片工作台订单列表
 * @method orderInfoByParams(array $params) 选片工作台订单信息
 * @method getSelectPhotoDirNameByParams(array $params) 获取选片文件夹名称接口
 * @method markOrderSelectPhotoByParams(array $params) 标记订单去选片
 * @method saveRepairPhotoRemarkByParams(array $params) 保存修图备注
 * @method getRepairPhotoRemarkByProcessIdByParams(array $params) 通过processId获取修图备注
 * @method orderInfoV2ByParams(array $params) 查询订单信息V2
 * @method listV2ByParams(array $params) 选片工作台订单列表V2
 */
class Order {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "SelectPhotoWorkbench\\Order";

    /**
     * 选片工作台订单列表
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderListDTO
    */
    public static function orderList (?\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\Cmd\OrderListCmd $orderListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList($orderListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderListDTO"
        );
    }
    /**
     * 选片工作台订单信息
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderList\OrderInfoDTO
    */
    public static function orderInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderList\OrderInfoDTO"
        );
    }
    /**
     * 获取选片文件夹名称接口
     * @return  string
    */
    public static function getSelectPhotoDirName (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelectPhotoDirName(["orderId" => $orderId]);
    }
    /**
     * 标记订单去选片
     * @return  bool
    */
    public static function markOrderSelectPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->markOrderSelectPhoto(["orderId" => $orderId]);
    }
    /**
     * 保存修图备注
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function saveRepairPhotoRemark (int $processId, string $repairPhotoRemark, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveRepairPhotoRemark(array_merge($_params, ["processId" => $processId, "repairPhotoRemark" => $repairPhotoRemark]));
    }
    /**
     * 通过processId获取修图备注
     * @return  string
    */
    public static function getRepairPhotoRemarkByProcessId (int $processId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRepairPhotoRemarkByProcessId(["processId" => $processId]);
    }
    /**
     * 查询订单信息V2
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderV2\PaperlessOrderDTO
    */
    public static function orderInfoV2 (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderInfoV2(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderV2\PaperlessOrderDTO"
        );
    }
    /**
     * 选片工作台订单列表V2
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderV2\OrderListDTO
    */
    public static function listV2 (?\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\Cmd\WorkbenchOrderListCmd $workbenchOrderListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listV2($workbenchOrderListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\OrderV2\OrderListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}