<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 18:04:13
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SecondRetoucher
 * @method orderDetailByParams(array $params) 订单详情
 * @method getLookingPhotoExtendInfoByParams(array $params) 获取看片照片数量,时长,看片通知时间
 * @method submitFinalPhotoAsyncByParams(array $params) 提交最终成片(异步)
 * @method hookUploadPhotoByParams(array $params) hook照片上传
 */
class SecondRetoucher {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\SecondRetoucher";

    /**
     * 订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function orderDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDetail($_params);
    }
    /**
     * 获取看片照片数量,时长,看片通知时间
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\ReserveLookPhoto\GetLookingPhotoExtendInfoDTO
    */
    public static function getLookingPhotoExtendInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getLookingPhotoExtendInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\ReserveLookPhoto\GetLookingPhotoExtendInfoDTO"
        );
    }
    /**
     * 提交最终成片(异步)
     * @return  bool
    */
    public static function submitFinalPhotoAsync (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\SecondRetoucher\SubmitFinalPhotoAsyncCmd $submitFinalPhotoAsyncCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhotoAsync($submitFinalPhotoAsyncCmd);
    }
    /**
     * hook照片上传
     * @return  bool
    */
    public static function hookUploadPhoto (int $streamId, string $path, int $photoId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUploadPhoto(["streamId" => $streamId, "path" => $path, "photoId" => $photoId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}