<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-18 18:00:47
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 * @method getCollectionStoresByParams(array $params) 获取集合店列表
 * @method clearCollectStoresCacheByParams(array $params) 清除中台缓存
 * @method getNasCollectionStoreByParams(array $params) 获取nas集合店
 */
class Store {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Api\\Store";

    /**
     * 获取集合店列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCollectionStores () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCollectionStores();
    }
    /**
     * 清除中台缓存
     * @return  mixed
    */
    public static function clearCollectStoresCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCollectStoresCache();
    }
    /**
     * 获取nas集合店
     * @return  array
    */
    public static function getNasCollectionStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNasCollectionStore(["storeId" => $storeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}