<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-25 18:32:43
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\SelectPhotoWorkbench;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Workbench
 */
class Workbench {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "SelectPhotoWorkbench\\Workbench";

    /**
     * 获取全国所有门店
     * @return  array
    */
    public static function allStores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allStores(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取可选的门店列表(含兼岗)
     * @return  array
    */
    public static function storeList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeList(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取门店摄影师列表(含兼岗)
     * @return  array
    */
    public static function cameramanList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cameramanList(),
            "\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\DTO\StaffDTO[]"
        );
    }
    /**
     * 切换门店
     * @return  bool
    */
    public static function selectStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectStore(["storeId" => $storeId]);
    }
    /**
     * 获取当前门店信息
     * @return  mixed
    */
    public static function getCurrentStoreInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentStoreInfo();
    }
    /**
     * 获取cp1各版本初始化文件
     * @return  array
    */
    public static function getCP1VersionsZip () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCP1VersionsZip();
    }
    /**
     * nas问题上报
     * @return  bool
    */
    public static function reportNasProblem (\Mainto\Bridge\Structs\FamilyPaperless\SelectPhotoWorkbench\Cmd\ReportNasProblemCmd $reportNasProblemCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportNasProblem($reportNasProblemCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}