<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-10 17:52:46
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PictureOnline
 */
class PictureOnline {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\PictureOnline";

    /**
     * 在线看片设置打印
     * @return  bool
    */
    public static function setPrint (string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPrint(["recordNo" => $recordNo]);
    }
    /**
     * 在线看片详情
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PictureOnlineDetailDTO
    */
    public static function detail (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PictureOnlineDetailDTO"
        );
    }
    /**
     * 修改取片方式
     * @return  bool
    */
    public static function changeTakePhotoType (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\ChangeTakePhotoTypeCmd $changeTakePhotoTypeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeTakePhotoType($changeTakePhotoTypeCmd);
    }
    /**
     * 标记发件
     * @return  bool
    */
    public static function addPostNum (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\AddPostNumCmd $addPostNumCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPostNum($addPostNumCmd);
    }
    /**
     * 根据看片单ids获取打印尺寸
     * @return  array
    */
    public static function getPhotoSizeByIds (array $ids) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeByIds(["ids" => $ids]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PhotoSizeListDTO[]"
        );
    }
    /**
     * 照片打印列表
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordPageDTO
    */
    public static function photoPrintList (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PrintListCmd $printListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoPrintList($printListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordPageDTO"
        );
    }
    /**
     * 标记取片
     * @return  bool
    */
    public static function hasTaken (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PictureOnlineHasTakenCmd $pictureOnlineHasTakenCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasTaken($pictureOnlineHasTakenCmd);
    }
    /**
     * 打印照片详情
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordDetailDTO
    */
    public static function watchRecord (int $recordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->watchRecord(["recordId" => $recordId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordDetailDTO"
        );
    }
    /**
     * 列表数量统计
     * @return  array
    */
    public static function watchRecordStatistic (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PrintListCmd $printListCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->watchRecordStatistic($printListCmd);
    }
    /**
     * 一键下单
     * @return  bool
    */
    public static function expressPlaceOrder (int $watchRecordId, string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->expressPlaceOrder(["watchRecordId" => $watchRecordId, "recordNo" => $recordNo]);
    }
    /**
     * 快递详情
     * @return  array
    */
    public static function expressDetail (int $watchRecordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->expressDetail(["watchRecordId" => $watchRecordId]);
    }
    /**
     * 取消寄件
     * @return  bool
    */
    public static function expressCancel (int $watchRecordId, string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->expressCancel(["watchRecordId" => $watchRecordId, "recordNo" => $recordNo]);
    }
    /**
     * 在线看片试点门店
     * @return  array
    */
    public static function watchRecordExperimentalStoreId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->watchRecordExperimentalStoreId();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}