<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-28 19:47:08
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PaperlessOrder
 */
class PaperlessOrder {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Api\\PaperlessOrder";

    /**
     * 无纸化订单列表
     * @return  array
    */
    public static function paperlessOrderList (array $orderIds, string $stage, array $storeIds, bool $isPrinted, bool $isPosted, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paperlessOrderList(["orderIds" => $orderIds, "stage" => $stage, "storeIds" => $storeIds, "isPrinted" => $isPrinted, "isPosted" => $isPosted, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取第一次看片完成的看片师id
     * @return  int
    */
    public static function getFirstFinishLookPhotoStaffId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFirstFinishLookPhotoStaffId(["orderId" => $orderId]);
    }
    /**
     * 获取订单摄影信息
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\SalaryProduct\SalaryOrderDTO
    */
    public static function orderPhotographyInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPhotographyInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\SalaryProduct\SalaryOrderDTO"
        );
    }
    /**
     * 取消引逗
     * @return  array
    */
    public static function cancelTease (array $processIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelTease(["processIds" => $processIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}