<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-29 15:13:49
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Service\StaffWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffWorkState
 */
class StaffWorkState {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Service\\StaffWork\\StaffWorkState";

    /**
     * 获取伙伴某个门店工作状态
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\StaffWorkState\WorkStatusDTO
    */
    public static function workStatus (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\WorkStatusCmd $workStatusCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->workStatus($workStatusCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\StaffWorkState\WorkStatusDTO"
        );
    }
    /**
     * 开始工作
     * @return  bool
    */
    public static function beginWork (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\BeginWorkCmd $beginWorkCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->beginWork($beginWorkCmd);
    }
    /**
     * 结束工作
     * @return  bool
    */
    public static function endWork (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\EndWorkCmd $endWorkCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->endWork($endWorkCmd);
    }
    /**
     * 挂起
     * @return  bool
    */
    public static function hang (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\HangCmd $hangCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hang($hangCmd);
    }
    /**
     * 取消挂起
     * @return  bool
    */
    public static function cancelHang (\Mainto\Bridge\Structs\FamilyPaperless\Service\Cmd\CancelHangCmd $cancelHangCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang($cancelHangCmd);
    }
    /**
     * 获取伙伴工作门店信息
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\StaffWorkState\WorkingStoreStatusDTO
    */
    public static function workingStoreStatus (int $staffId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->workingStoreStatus(["staffId" => $staffId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Service\DTO\StaffWorkState\WorkingStoreStatusDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}