<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $params)
 * @method retouchSignInByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $params)
 * @method reviewStoreListByParams(array $params)
 * @method getProcessInfoByParams(array $params)
 * @method technicalPointsByParams(array $params)
 * @method technicalPointsHistoryByParams(array $params)
 * @method updateTechnicalPointsByParams(array $params)
 * @method productRetouchStyleByParams(array $params)
 * @method evaluateRetoucherByParams(array $params)
 * @method cloudProductInfoByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $userSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function userSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $userSignInCmd) {
        return self::getClass()->userSignIn($userSignInCmd);
    }


    /**
     * 看片签到
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $retouchSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retouchSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $retouchSignInCmd) {
        return self::getClass()->retouchSignIn($retouchSignInCmd);
    }


    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * 获取process信息
     *
     * @param  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessInfo (int $processId) {
        return self::getClass()->getProcessInfo([
            "processId" => $processId,
        ]);
    }

    /**
     * 获取订单下产品的技术要点
     *
     * @throws  \Exception
     * @return  array
     */
    public static function technicalPoints ($context) {
        return self::getClass()->technicalPoints();
    }

    /**
     * 获取订单下产品的技术要点（包含被删除的技术要点）
     *
     * @throws  \Exception
     * @return  array
     */
    public static function technicalPointsHistory ($context) {
        return self::getClass()->technicalPointsHistory();
    }

    /**
     * 更新订单下产品的技术要点
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTechnicalPoints ($context) {
        return self::getClass()->updateTechnicalPoints();
    }

    /**
     * 获取云端产品的修图风格
     *
     * @support  int $productId 产品ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productRetouchStyle ($context) {
        return self::getClass()->productRetouchStyle([
            "context" => $context,
        ]);
    }

    /**
     * 评价修图师风格
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function evaluateRetoucher ($context) {
        return self::getClass()->evaluateRetoucher();
    }

    /**
     * 获取产品信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function cloudProductInfo ($context) {
        return self::getClass()->cloudProductInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Paperless\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Paperless\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}