<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-06 15:33:48
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Paperless\\Order";

    /**
     * 更新订单备注信息
     *
     */
    public static function saveNote (int $orderId, string $note): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote(["orderId" => $orderId, "note" => $note, ]);
    }
    /**
     * 门店流程数量统计
     *
     */
    public static function getOrderStageNums (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\GetOrderStageNumsCmd $getOrderStageNumsCmd = null): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStageNums($getOrderStageNumsCmd);
    }
    /**
     * 指定订单接单伙伴
     *
     */
    public static function assignStageStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\AssignStageStaffCmd $assignStageStaffCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignStageStaff($assignStageStaffCmd);
    }
    /**
     * 化妆阶段更换伙伴 - 多人协作
     *
     */
    public static function makeUpChangeStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\MakeUp\MakeUpChangeStaffCmd $makeUpChangeStaffCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->makeUpChangeStaff($makeUpChangeStaffCmd);
    }
    /**
     * 清除订单接单伙伴
     *
     */
    public static function cancelAssignStageStaff (int $orderId, string $stage): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssignStageStaff(["orderId" => $orderId, "stage" => $stage, ]);
    }
    /**
     * 挂起订单
     *
     */
    public static function hang (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->hang(["orderId" => $orderId, ]);
    }
    /**
     * 取消挂起订单
     *
     */
    public static function cancelHang (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang(["orderId" => $orderId, ]);
    }
    /**
     * 更换伙伴
     *
     */
    public static function changeStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\ChangeStaffCmd $changeStaffCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStaff($changeStaffCmd);
    }
    /**
     * 更新接单顺序
     *
     */
    public static function updateSort (int $orderId, int $sort): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSort(["orderId" => $orderId, "sort" => $sort, ]);
    }
    /**
     * 获取订单可选的伙伴列表
     *
     */
    public static function getOrderAvailableStaffs (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderAvailableStaffs(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单预指派的伙伴信息
     *
     */
    public static function getOrderPreAssignStaffs (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderPreAssignStaffs(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单当前指派的伙伴信息
     *
     */
    public static function getOrderCurrentAssignStaffs (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderCurrentAssignStaffs(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单当前指派的伙伴信息（蓝标）
     *
     */
    public static function getOrderCurrentAssignStaffs2 (int $orderId): \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\OrderPreAssignStaffsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderCurrentAssignStaffs2(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\OrderPreAssignStaffsDTO"
        );
    }
    /**
     * 获取订单可接单伙伴列表
     *
     */
    public static function getCanTakeOrderStaffIds (int $orderId): \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\CanTakeOrderStaffDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCanTakeOrderStaffIds(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\CanTakeOrderStaffDTO"
        );
    }
    /**
     * 退回至等待摄影
     *
     */
    public static function backWaitPhotography (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitPhotography(["orderId" => $orderId, ]);
    }
    /**
     * 退回至等待化妆
     *
     */
    public static function backWaitMakeUp (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitMakeUp(["orderId" => $orderId, ]);
    }
    /**
     * 订单中是否存在已下架产品
     *
     */
    public static function hasOffProducts (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasOffProducts(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单的伙伴列表
     *
     */
    public static function getStageStaffs (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStageStaffs(["orderId" => $orderId, ]);
    }
    /**
     * 恢复到等待拍摄状态
     *
     */
    public static function recover (int $orderId, string $token): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->recover(["orderId" => $orderId, "token" => $token, ]);
    }
    /**
     * 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
     *
     */
    public static function checkNeedPaperless (int $storeId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkNeedPaperless(["storeId" => $storeId, ]);
    }
    /**
     * 更新订单下产品的技术要点
     *
     */
    public static function updateTechnicalPoints (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\TechnicalPoint\UpdateOrderTechnicalPointCmd $updateOrderTechnicalPointCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTechnicalPoints($updateOrderTechnicalPointCmd);
    }
    /**
     * 获取订单下产品的技术要点
     *
     */
    public static function technicalPoints (int $orderId, bool $withDelete = false): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->technicalPoints(["orderId" => $orderId, "withDelete" => $withDelete, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDTO[]"
        );
    }
    /**
     * 获取订单下产品的技术要点（包含删除的数据）
     *
     */
    public static function technicalPointsHistory (int $orderId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->technicalPointsHistory(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDTO[]"
        );
    }
    /**
     * 获取云端订单下所有正常流水
     *
     */
    public static function cloudList (int $orderId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cloudList(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\CloudListDTO[]"
        );
    }
    /**
     * 获取订单的协作分配信息
     *
     */
    public static function getMakeUpAssignStaffs (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\OrderMakeUpAssistantCmd $orderMakeUpAssistantCmd): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMakeUpAssignStaffs($orderMakeUpAssistantCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessAssistantPeopleDTO[]"
        );
    }
    /**
     * 取消协作
     *
     */
    public static function cancelAssist (int $processId, int $staffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssist(["processId" => $processId, "staffId" => $staffId, ]);
    }
    /**
     * 获取订单的协作工作量信息
     *
     */
    public static function getAssignWorkloads (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Workload\OrderAssignWorkloadCmd $orderAssignWorkloadCmd): \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Workload\OrderAssistantWorkloadDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAssignWorkloads($orderAssignWorkloadCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Workload\OrderAssistantWorkloadDTO"
        );
    }
    /**
     * 更新订单下产品的登记地
     *
     */
    public static function updatePhotoSizeAreas (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PhotoSizeArea\UpdatePhotoSizeAreaCmd $updatePhotoSizeAreaCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePhotoSizeAreas($updatePhotoSizeAreaCmd);
    }
    /**
     * 获取可录入登记地的产品ids
     *
     */
    public static function getNeedPhotoSizeAreas (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNeedPhotoSizeAreas(["orderId" => $orderId, ]);
    }
    /**
     * 通过订单id获取登记地尺寸信息
     *
     */
    public static function getPhotoSizeDetailByOrderId (int $orderId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeDetailByOrderId(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessPhotoSizeDTO[]"
        );
    }
    /**
     * 订单是否需要协作化妆师
     *
     */
    public static function needAssistant (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->needAssistant(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}