<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-06 10:27:01
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\OnlineShooting;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShootingStudio
 */
class ShootingStudio {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "OnlineShooting\\ShootingStudio";

    /**
     * 获取可选的门店列表
     *
     */
    public static function stores (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stores(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取门店影棚列表
     *
     */
    public static function studioBindList (int $storeId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBindList(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindListDTO[]"
        );
    }
    /**
     * 绑定门店影棚和设备
     *
     */
    public static function studioBind (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\StudioBindCmd $studioBindCmd): \Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBind($studioBindCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO"
        );
    }
    /**
     * 验证联机拍摄应用登录
     *
     */
    public static function login (string $code): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->login(["code" => $code, ]);
    }
    /**
     * 上报当前应用IP
     *
     */
    public static function updateAppIP (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\UpdateIPCmd $updateIPCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAppIP($updateIPCmd);
    }
    /**
     * 获取当前影棚未初始化的流程
     *
     */
    public static function getNotReadyProcess (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNotReadyProcess(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\ProcessShootingAppNotReadyDTO[]"
        );
    }
    /**
     * 设置影棚订单初始化成功
     *
     */
    public static function setProcessReady (int $processId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProcessReady(["processId" => $processId, ]);
    }
    /**
     * 获取当前门店摄影机ip列表
     *
     */
    public static function shootingAppIPs (int $storeId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->shootingAppIPs(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioDetailDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}