<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-11-28 16:35:55
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Review
 */
class Review {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Review";

    /**
     * 绑定审核人id
     *
     */
    public static function bindChecker (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PaperlessReview\BeginReviewCmd $beginReviewCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindChecker($beginReviewCmd);
    }
    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     */
    public static function getWaitReviewCount (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewCount();
    }
    /**
     * 待审核订单列表
     *
     */
    public static function getWaitReviewList (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PaperlessReview\WaitReviewListCmd $waitReviewListCmd = null): \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\GetWaitReviewListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewList($waitReviewListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\GetWaitReviewListDTO"
        );
    }
    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     */
    public static function queryWaitFinishList (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PaperlessReview\WaitReviewListCmd $waitReviewListCmd = null): \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\GetWaitReviewListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryWaitFinishList($waitReviewListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\GetWaitReviewListDTO"
        );
    }
    /**
     * 我的审核
     *
     */
    public static function getMyReviewList (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyReviewList(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\MyReviewListDTO[]"
        );
    }
    /**
     * 提交审核
     *
     */
    public static function review (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PaperlessReview\ReviewCmd $reviewCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->review($reviewCmd);
    }
    /**
     * 看片审核历史列表
     *
     */
    public static function reviewHistory (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PaperlessReview\HistoryCmd $historyCmd = null): \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\ReviewHistoryPagerDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->reviewHistory($historyCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Review\ReviewHistoryPagerDTO"
        );
    }
    /**
     * 发送看片通知
     *
     */
    public static function sendWatchPhotoNotify (int $orderId, bool $reviewSend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWatchPhotoNotify(["orderId" => $orderId, "reviewSend" => $reviewSend, ]);
    }
    /**
     * 获取未读流水
     *
     */
    public static function getUnreadCount (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnreadCount();
    }
    /**
     * 清除未完成的订单列表提示
     *
     */
    public static function cleanNotify (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanNotify();
    }
    /**
     * 查看未读流水
     *
     */
    public static function checkUnreadStream (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUnreadStream();
    }
    /**
     * 获取在线看片师信息
     *
     */
    public static function getPictureOnlineRetoucher (int $staffId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureOnlineRetoucher(["staffId" => $staffId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}