<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderProductsByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getWaitingCountByParams(array $params)
 * @method getPhotographicPoseByParams(array $params)
 */
class OrderDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单购买的产品
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderProducts (int $orderId) {
        return self::getClass()->getOrderProducts([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 更新订单备注信息
     *
     * @support  int $orderId 订单ID [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  bool $append 是否追加 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveNote ($context) {
        return self::getClass()->saveNote([
            "context" => $context,
        ]);
    }

    /**
     * 获取等待数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitingCount ($context) {
        return self::getClass()->getWaitingCount();
    }

    /**
     * 获取订单摄影动作
     *
     * @support  array $orderIds 订单IDS [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographicPose ($context) {
        return self::getClass()->getPhotographicPose([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\OrderDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\OrderDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}