<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOverUploadReasonInfoByParams(array $params)
 */
class OverUploadReason {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WARN: project-paperless 调用
     *
     * @param  int $id 原因id [ require true ]
     * @param  int $childId 子原因id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\OverUploadReasonInfoDTO
     */
    public static function getOverUploadReasonInfo (int $id, int $childId = null) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOverUploadReasonInfo([
                            "id" => $id,
                            "childId" => $childId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\OverUploadReasonInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\OverUploadReason');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\OverUploadReason');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}