<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method retakeCheckByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\RetakeCheckCmd $params)
 */
class RiskControl {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * retakeCheck
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\RetakeCheckCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retakeCheck (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\RetakeCheckCmd $cmd) {
        return self::getClass()->retakeCheck($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\RiskControl');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\RiskControl');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}