<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method changeTakePhotoTypeByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\ChangeTakePhotoTypeCmd $params)
 * @method addPostNumByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\AddPostNumCmd $params)
 * @method getPhotoSizeByIdsByParams(array $params)
 * @method photoPrintListByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PrintListCmd $params)
 * @method hasTakenByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PictureOnlineHasTakenCmd $params)
 * @method watchRecordByParams(array $params)
 * @method watchRecordStatisticByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\WatchRecordStatisticCmd $params)
 * @method expressPlaceOrderByParams(array $params)
 * @method expressDetailByParams(array $params)
 * @method expressCancelByParams(array $params)
 * @method watchRecordExperimentalStoreIdByParams(array $params)
 */
class PictureOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 在线看片设置打印
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPrint (string $recordNo) {
        return self::getClass()->setPrint([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 在线看片详情
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PictureOnlineDetailDTO
     */
    public static function detail (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "orderNum" => $orderNum,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PictureOnlineDetailDTO"
        );
    }

    /**
     * 修改取片方式
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\ChangeTakePhotoTypeCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeTakePhotoType (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\ChangeTakePhotoTypeCmd $cmd) {
        return self::getClass()->changeTakePhotoType($cmd);
    }


    /**
     * 标记发件
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\AddPostNumCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addPostNum (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\AddPostNumCmd $cmd) {
        return self::getClass()->addPostNum($cmd);
    }


    /**
     * 根据看片单ids获取打印尺寸
     *
     * @param  array $ids 看片单ids [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PhotoSizeListDTO[]
     */
    public static function getPhotoSizeByIds (array $ids) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoSizeByIds([
                            "ids" => $ids,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\PhotoSizeListDTO[]"
        );
    }

    /**
     * 照片打印列表
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PrintListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordPageDTO
     */
    public static function photoPrintList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PrintListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photoPrintList($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordPageDTO"
        );
    }


    /**
     * 标记取片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PictureOnlineHasTakenCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hasTaken (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\PictureOnlineHasTakenCmd $cmd) {
        return self::getClass()->hasTaken($cmd);
    }


    /**
     * 打印照片详情
     *
     * @param  int $recordId 看片记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordDetailDTO
     */
    public static function watchRecord (int $recordId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->watchRecord([
                            "recordId" => $recordId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\PictureOnline\WatchRecordDetailDTO"
        );
    }

    /**
     * 列表数量统计
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\WatchRecordStatisticCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function watchRecordStatistic (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\PictureOnline\WatchRecordStatisticCmd $cmd) {
        return self::getClass()->watchRecordStatistic($cmd);
    }


    /**
     * 一键下单
     *
     * @param  int $watchRecordId 看片记录id [ require true ]
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function expressPlaceOrder (int $watchRecordId, string $recordNo) {
        return self::getClass()->expressPlaceOrder([
            "watchRecordId" => $watchRecordId,
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 快递详情
     *
     * @param  int $watchRecordId 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function expressDetail (int $watchRecordId) {
        return self::getClass()->expressDetail([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 取消寄件
     *
     * @param  int $watchRecordId 看片记录id [ require true ]
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function expressCancel (int $watchRecordId, string $recordNo) {
        return self::getClass()->expressCancel([
            "watchRecordId" => $watchRecordId,
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 在线看片试点门店
     *
     * @throws  \Exception
     * @return  array
     */
    public static function watchRecordExperimentalStoreId () {
        return self::getClass()->watchRecordExperimentalStoreId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\PictureOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\PictureOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}