<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindOrderUploadByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $params)
 * @method revokeCloudStreamByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $params)
 * @method revokeOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method excellencePhotoUploadSettingByParams(array $params)
 * @method getOverUploadReasonsByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单添加至摄影师
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindOrderUpload (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $cmd) {
        return self::getClass()->bindOrderUpload($cmd);
    }


    /**
     * 撤回照片(流水维度)
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeCloudStream (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $cmd) {
        return self::getClass()->revokeCloudStream($cmd);
    }


    /**
     * 撤回订单照片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeOrder (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $cmd) {
        return self::getClass()->revokeOrder($cmd);
    }


    /**
     * 云端流水详情
     *
     * @support  int $cloudStreamId 流水id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo () {
        return self::getClass()->getCloudStreamInfo([
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo () {
        return self::getClass()->getHistoryInfo([
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList([
        ]);
    }

    /**
     * 批量获取流水详情
     *
     * @support  array $cloudStreamIds 流水ids [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds([
        ]);
    }

    /**
     * 当前门店是否需要上传优秀底片
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ExcellencePhotoUploadSettingDTO
     */
    public static function excellencePhotoUploadSetting () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->excellencePhotoUploadSetting(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ExcellencePhotoUploadSettingDTO"
        );
    }

    /**
     * 获取超传原因列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\OverUploadReason\OverUploadReasonDTO[]
     */
    public static function getOverUploadReasons () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOverUploadReasons(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\OverUploadReason\OverUploadReasonDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}