<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method lookListByParams(array $params)
 * @method addReservationByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method cancelLookPhotoReserveTimeByParams(array $params)
 * @method allOrderListByParams(array $params)
 * @method bigOrderListByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\BigOrderListCmd $params)
 * @method lookingReservationByParams(array $params)
 * @method lookReservationDetailByParams(array $params)
 * @method bigOrderByParams(array $params)
 */
class ReserveLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片排单表可约时间
     *
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function lookList () {
        return self::getClass()->lookList([
        ]);
    }

    /**
     * 添加看片排单表预约
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $orderTime 节点时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addReservation () {
        return self::getClass()->addReservation([
        ]);
    }

    /**
     * 修改看片预约时间
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $lookPhotoReserveTime 看片预约时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeLookPhotoReserveTime () {
        return self::getClass()->changeLookPhotoReserveTime([
        ]);
    }

    /**
     * 取消看片预约
     *
     * @param  int $orderId 订单id [ require true ]
     * @support  string $look_photo_reserve_time 取消预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelLookPhotoReserveTime (int $orderId) {
        return self::getClass()->cancelLookPhotoReserveTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 预约看片全局订单查询
     *
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allOrderList () {
        return self::getClass()->allOrderList([
        ]);
    }

    /**
     * 大订单列表
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\BigOrderListCmd $cmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function bigOrderList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\BigOrderListCmd $cmd) {
        return self::getClass()->bigOrderList($cmd);
    }


    /**
     * 看片排单表
     *
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 截止日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function lookingReservation (string $dateStart, string $dateEnd) {
        return self::getClass()->lookingReservation([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * 看片预约排单表详情
     *
     * @support  string $selectDate 日期 [ require true ]
     * @support  int $storeId 门店 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function lookReservationDetail () {
        return self::getClass()->lookReservationDetail([
        ]);
    }

    /**
     * 是否是大订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bigOrder (int $orderId) {
        return self::getClass()->bigOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\ReserveLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\ReserveLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}