<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeStoreLookPhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\ChangeStoreLookPhotoCmd $params)
 * @method cancelChangeStoreLookPhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\CancelChangeStoreCmd $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) rpc调用, 线上未存在http调用
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\ChangeStoreLookPhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStoreLookPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\ChangeStoreLookPhotoCmd $cmd) {
        return self::getClass()->changeStoreLookPhoto($cmd);
    }


    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\CancelChangeStoreCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelChangeStoreLookPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\CancelChangeStoreCmd $cmd) {
        return self::getClass()->cancelChangeStoreLookPhoto($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}