<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $params)
 * @method evaluateRetoucherByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $params)
 * @method reworkStreamByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\ReworkStreamCmd $params)
 */
class CloudStream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询单条流水
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function detail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd) {
        return self::getClass()->detail($cmd);
    }


    /**
     * 评价修图师风格
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function evaluateRetoucher (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $cmd) {
        return self::getClass()->evaluateRetoucher($cmd);
    }


    /**
     * 重修流水
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\ReworkStreamCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function reworkStream (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\ReworkStreamCmd $cmd) {
        return self::getClass()->reworkStream($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}