<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookUserTakePhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更改取件方式发送伙伴钉钉通知
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookUserTakePhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $cmd) {
        return self::getClass()->hookUserTakePhoto($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}