<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method launchDetailByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $params)
 * @method terminateApplyByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $params)
 * @method detailByParams(array $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取创建二次看片需要的数据
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\AfterSaleOrder\LaunchDto
     */
    public static function launchDetail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->launchDetail($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\AfterSaleOrder\LaunchDto"
        );
    }


    /**
     * 创建二次看片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 取消售后单
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateApply (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $cmd) {
        return self::getClass()->terminateApply($cmd);
    }


    /**
     * 获取二次看片详情
     *
     * @param  int $afterSaleOrderId 售后订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\AfterSaleOrder\AfterSaleOrderDetailDTO
     */
    public static function detail (int $afterSaleOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "afterSaleOrderId" => $afterSaleOrderId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\AfterSaleOrder\AfterSaleOrderDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}