<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method autoWatchPhotoNotifyByParams(array $params)
 * @method autoSetFinishedPhotoByParams(array $params)
 */
class LookingPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function autoWatchPhotoNotify (int $orderId) {
        return self::getClass()->autoWatchPhotoNotify([
            "orderId" => $orderId,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function autoSetFinishedPhoto (int $orderId) {
        return self::getClass()->autoSetFinishedPhoto([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\LookingPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\LookingPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}