<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitFinalPhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\SubmitFinalPhotoCmd $params)
 * @method clearAutoFinishPhotoByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method backWaitLookingByParams(array $params)
 * @method backWaitLookPhotoByParams(array $params)
 * @method kpsOrderAgainByParams(array $params)
 * @method kpSignInByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $params)
 * @method kpsBeginWorkByParams(array $params)
 * @method kpsEndWorkByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method getHistoryListByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\HistoryCmd $params)
 */
class LookingPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交最终成片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\SubmitFinalPhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitFinalPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\SubmitFinalPhotoCmd $cmd) {
        return self::getClass()->submitFinalPhoto($cmd);
    }


    /**
     * 清除自动看片完成订单的顾客满意片
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearAutoFinishPhoto (int $orderId) {
        return self::getClass()->clearAutoFinishPhoto([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice([
        ]);
    }

    /**
     * 订单退回等待看片
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLooking () {
        return self::getClass()->backWaitLooking([
        ]);
    }

    /**
     * 退回至看片排队中
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLookPhoto () {
        return self::getClass()->backWaitLookPhoto([
        ]);
    }

    /**
     * 看片师再来一单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function kpsOrderAgain () {
        return self::getClass()->kpsOrderAgain();
    }

    /**
     * 看片签到
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function kpSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $cmd) {
        return self::getClass()->kpSignIn($cmd);
    }


    /**
     * 看片师开始工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function kpsBeginWork () {
        return self::getClass()->kpsBeginWork();
    }

    /**
     * 看片师结束工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function kpsEndWork () {
        return self::getClass()->kpsEndWork();
    }

    /**
     * 看片师已接订单
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\LookingPhoto\OrderOnlineDTO[]
     */
    public static function getOrderOnline () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderOnline(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\LookingPhoto\OrderOnlineDTO[]"
        );
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\HistoryCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\LookingPhoto\LookPhotoHistoryPagerDTO
     */
    public static function getHistoryList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\LookingPhoto\HistoryCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHistoryList($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\LookingPhoto\LookPhotoHistoryPagerDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\LookingPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\LookingPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}