<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCheckConformOnlineOrderByParams(array $params)
 * @method checkConformOnlineOrderByParams(array $params)
 */
class PictureOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  mixed $orderInfo 订单信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCheckConformOnlineOrder ($orderInfo) {
        return self::getClass()->batchCheckConformOnlineOrder([
            "orderInfo" => $orderInfo,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkConformOnlineOrder (string $orderNo) {
        return self::getClass()->checkConformOnlineOrder([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\PictureOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\PictureOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}