<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method assignLookPhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ChangeStoreWatchPhoto\AssignLookPhotoCmd $params)
 * @method changeSecondReviewingByParams(array $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转门店看片指派
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ChangeStoreWatchPhoto\AssignLookPhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function assignLookPhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ChangeStoreWatchPhoto\AssignLookPhotoCmd $cmd) {
        return self::getClass()->assignLookPhoto($cmd);
    }


    /**
     * 转门店看片操作直接进入审核中
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeSecondReviewing () {
        return self::getClass()->changeSecondReviewing([
        ]);
    }

    /**
     * 取消转门店
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelChangeSecondRetouchStore () {
        return self::getClass()->cancelChangeSecondRetouchStore([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}