<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderDetailByParams(array $params)
 * @method getLookingPhotoExtendInfoByParams(array $params)
 * @method submitFinalPhotoAsyncByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\SecondRetoucher\SubmitFinalPhotoAsyncCmd $params)
 * @method hookUploadPhotoByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单详情
     *
     * @support  bool $withRetake 是否显示删除的流水信息 [ require false ]
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail([
        ]);
    }

    /**
     * 获取看片照片数量,时长,看片通知时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\ReserveLookPhoto\GetLookingPhotoExtendInfoDTO
     */
    public static function getLookingPhotoExtendInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getLookingPhotoExtendInfo([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\ReserveLookPhoto\GetLookingPhotoExtendInfoDTO"
        );
    }

    /**
     * 提交最终成片(异步)
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\SecondRetoucher\SubmitFinalPhotoAsyncCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitFinalPhotoAsync (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\SecondRetoucher\SubmitFinalPhotoAsyncCmd $cmd) {
        return self::getClass()->submitFinalPhotoAsync($cmd);
    }


    /**
     * hook照片上传
     *
     * @param  int $streamId 流水id [ require true ]
     * @param  string $path 照片路径 [ require true ]
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookUploadPhoto (int $streamId, string $path, int $photoId = 0) {
        return self::getClass()->hookUploadPhoto([
            "streamId" => $streamId,
            "path" => $path,
            "photoId" => $photoId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}