<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Message;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeSalesByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method partRefundOrderByParams(array $params)
 * @method orderRetakeSaleByParams(array $params)
 * @method syncPassProductIdsByParams(array $params)
 * @method hookCloudFinishStreamByParams(array $params)
 * @method hookCloudDeleteStreamByParams(array $params)
 * @method hookHimoSetWorkloadsByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookHimoSetWorkloadCmd $params)
 * @method hookWaitOrderDingUserNotifyByParams(array $params)
 * @method delaySendBigOrderNoticeByParams(array $params)
 * @method hookPictureOnlineTakeOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineTakeOrderCmd $params)
 * @method hookPictureOnlineCompleteOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineCompleteOrderCmd $params)
 * @method hookUserTakePhotoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单修改拍摄产品通知
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  int $inputStaffId 操作人id [ require false ]
     * @support  array $createSaleList 新增拍摄产品 [ require false ]
     * @support  array $removeSaleList 删除拍摄产品 [ require false ]
     * @support  array $modifySaleList 拍摄产品变更 [ require false ]
     * @support  array $unModifySaleList 拍摄产品未变化 [ require false ]
     * @support  array $replaceSaleList 替换拍摄产品 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeSales () {
        return self::getClass()->changeSales([
        ]);
    }

    /**
     * 关闭订单流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  string $changeReserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder([
        ]);
    }

    /**
     * 退回到等待拍摄流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting([
        ]);
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $closedSaleIds 退款sale_id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundOrder () {
        return self::getClass()->refundOrder([
        ]);
    }

    /**
     * partRefundOrder
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $orderSkuList 退款后skuList [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function partRefundOrder () {
        return self::getClass()->partRefundOrder([
        ]);
    }

    /**
     * orderRetakeSale
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $retakeNewStoreId 重拍之后新门店id [ require false ]
     * @support  int $retakeNewOrderId 重拍之后新建的订单id [ require false ]
     * @support  bool $skuAllRetake 是否全部重拍 [ require false ]
     * @support  array $retakeOrderSakeSku 重拍的拍摄产品 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderRetakeSale () {
        return self::getClass()->orderRetakeSale([
        ]);
    }

    /**
     * 更新通关产品ids
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  array $productIds 通关产品ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncPassProductIds () {
        return self::getClass()->syncPassProductIds([
        ]);
    }

    /**
     * 接收云端流水完成事件
     *
     * @support  string $stream_num 流水号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloudFinishStream () {
        return self::getClass()->hookCloudFinishStream([
        ]);
    }

    /**
     * 接收云端流水删除事件
     *
     * @support  string $stream_num 流水号 [ require false ]
     * @support  int $delete_operator_id 操作删除流水的员工id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloudDeleteStream () {
        return self::getClass()->hookCloudDeleteStream([
        ]);
    }

    /**
     * 接收录工作量事件
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookHimoSetWorkloadCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookHimoSetWorkloads (\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookHimoSetWorkloadCmd $cmd) {
        return self::getClass()->hookHimoSetWorkloads($cmd);
    }


    /**
     * 订单等待流程过长通知门店伙伴
     *
     * @param  int $orderId 订单号 [ require true ]
     * @param  array $staffIds 通知伙伴数组 [ require true ]
     * @param  int $noticeTime 超时分钟数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWaitOrderDingUserNotify (int $orderId, array $staffIds, int $noticeTime) {
        return self::getClass()->hookWaitOrderDingUserNotify([
            "orderId" => $orderId,
            "staffIds" => $staffIds,
            "noticeTime" => $noticeTime,
        ]);
    }

    /**
     * 大订单一小时内未预约提示
     *
     * @param  int $order_id 订单Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendBigOrderNotice (int $order_id) {
        return self::getClass()->delaySendBigOrderNotice([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 接收在线看片接单事件
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineTakeOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPictureOnlineTakeOrder (\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineTakeOrderCmd $cmd) {
        return self::getClass()->hookPictureOnlineTakeOrder($cmd);
    }


    /**
     * 接收在线看片完成事件
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineCompleteOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPictureOnlineCompleteOrder (\Mainto\Bridge\Structs\FamilyPaperless\Message\Cmd\HookPictureOnlineCompleteOrderCmd $cmd) {
        return self::getClass()->hookPictureOnlineCompleteOrder($cmd);
    }


    /**
     * 更改取件方式发送伙伴钉钉通知
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookUserTakePhoto (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Hook\HookUserTakePhotoCmd $cmd) {
        return self::getClass()->hookUserTakePhoto($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Message\MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Message\MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}