<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method launchDetailByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $params)
 * @method terminateApplyByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $params)
 * @method detailByParams(array $params)
 */
class OrderAfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取二次看片创建售后订单详情
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function launchDetail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\LaunchCmd $dto) {
        return self::getClass()->launchDetail($dto);
    }


    /**
     * 创建二次看片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\CreateAfterSaleCmd $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 取消售后单
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateApply (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\OrderAfterSale\TerminateApplyCmd $dto) {
        return self::getClass()->terminateApply($dto);
    }


    /**
     * 获取二次看片创建售后订单详情
     *
     * @param  int $afterSaleOrderId 售后订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $afterSaleOrderId) {
        return self::getClass()->detail([
            "afterSaleOrderId" => $afterSaleOrderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}