<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $params)
 * @method retouchSignInByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $params)
 * @method reviewStoreListByParams(array $params)
 * @method getProcessInfoByParams(array $params)
 * @method getProcessIdsBySaleIdsByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $userSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function userSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\UserSignInCmd $userSignInCmd) {
        return self::getClass()->userSignIn($userSignInCmd);
    }


    /**
     * 看片签到
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $retouchSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retouchSignIn (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\RetouchSignInCmd $retouchSignInCmd) {
        return self::getClass()->retouchSignIn($retouchSignInCmd);
    }


    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * 获取process信息
     *
     * @param  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessInfoDTO
     */
    public static function getProcessInfo (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProcessInfo([
                            "processId" => $processId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessInfoDTO"
        );
    }

    /**
     * 通过sale ids批量获取process id[用于伙伴请假 化妆师调整]
     *
     * @param  array $saleIds 销售ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessIdsBySaleIds (array $saleIds) {
        return self::getClass()->getProcessIdsBySaleIds([
            "saleIds" => $saleIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Paperless\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Paperless\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}