<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrderListByParams(array $params)
 * @method getMakeUpProcessesByParams(array $params)
 */
class PaperlessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @support  array $orderIds orderIds [ require false ]
     * @support  string $stage 无纸化订单阶段 [ require false ]
     * @support  int $storeId 无纸化订单阶段 [ require false ]
     * @support  bool $isPrinted 是否打印 [ require false ]
     * @support  bool $isPosted 是否邮寄 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function paperlessOrderList () {
        return self::getClass()->paperlessOrderList([
        ]);
    }

    /**
     * 无纸化订单列表
     *
     * @param  array $orderIds orderIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMakeUpProcesses (array $orderIds) {
        return self::getClass()->getMakeUpProcesses([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Api\PaperlessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Api\PaperlessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}