<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductsByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method updatePhotoSizeAreasByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PhotoSizeArea\UpdatePhotoSizeAreaCmd $params)
 * @method getNeedPhotoSizeAreasByParams(array $params)
 * @method getPhotoSizeDetailByParams(array $params)
 */
class ProductDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店所有产品
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetProductsDTO[]
     */
    public static function getProducts () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProducts(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetProductsDTO[]"
        );
    }

    /**
     * 门店产品详情
     *
     * @support  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetProductDetailDTO
     */
    public static function getProductDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductDetail([
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetProductDetailDTO"
        );
    }

    /**
     * 更新订单下产品的登记地-伙伴端
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PhotoSizeArea\UpdatePhotoSizeAreaCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updatePhotoSizeAreas (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PhotoSizeArea\UpdatePhotoSizeAreaCmd $cmd) {
        return self::getClass()->updatePhotoSizeAreas($cmd);
    }


    /**
     * 根据订单id获取产品是否需要录入登记地-伙伴端
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNeedPhotoSizeAreas (int $orderId) {
        return self::getClass()->getNeedPhotoSizeAreas([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取尺寸详情-伙伴端
     *
     * @param  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetPhotoSizeDetailDTO
     */
    public static function getPhotoSizeDetail (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoSizeDetail([
                            "processId" => $processId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetPhotoSizeDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\ProductDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\ProductDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}