<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Message;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeSalesByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method partRefundOrderByParams(array $params)
 * @method orderRetakeSaleByParams(array $params)
 * @method syncPassProductIdsByParams(array $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单修改拍摄产品通知
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  int $inputStaffId 操作人id [ require false ]
     * @support  array $createSaleList 新增拍摄产品 [ require false ]
     * @support  array $removeSaleList 删除拍摄产品 [ require false ]
     * @support  array $modifySaleList 拍摄产品变更 [ require false ]
     * @support  array $unModifySaleList 拍摄产品未变化 [ require false ]
     * @support  array $replaceSaleList 替换拍摄产品 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeSales () {
        return self::getClass()->changeSales([
        ]);
    }

    /**
     * 关闭订单流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  string $changeReserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder([
        ]);
    }

    /**
     * 退回到等待拍摄流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting([
        ]);
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $closedSaleIds 退款sale_id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundOrder () {
        return self::getClass()->refundOrder([
        ]);
    }

    /**
     * partRefundOrder
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $orderSkuList 退款后skuList [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function partRefundOrder () {
        return self::getClass()->partRefundOrder([
        ]);
    }

    /**
     * orderRetakeSale
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $retakeNewStoreId 重拍之后新门店id [ require false ]
     * @support  int $retakeNewOrderId 重拍之后新建的订单id [ require false ]
     * @support  bool $skuAllRetake 是否全部重拍 [ require false ]
     * @support  array $retakeOrderSakeSku 重拍的拍摄产品 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderRetakeSale () {
        return self::getClass()->orderRetakeSale([
        ]);
    }

    /**
     * 更新通关产品ids
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  array $productIds 通关产品ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncPassProductIds () {
        return self::getClass()->syncPassProductIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Message\MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Message\MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}