<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $params)
 * @method uploadListByParams(array $params)
 * @method tabRefundNotDealWithByParams(array $params)
 * @method tabOrderUpdateNotDealWithByParams(array $params)
 * @method variousUploadedTotalByParams(array $params)
 * @method uploadPhotoCloudByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $params)
 * @method getOrderProductUploadedNumByParams(array $params)
 */
class UploadRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师中心：搜索订单
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\SearchOrderDTO[]
     */
    public static function searchOrder (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchOrder($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\SearchOrderDTO[]"
        );
    }


    /**
     * 上传记录列表
     *
     * @support  string $type 查询类型 [ require true ]
     * @support  string $searchTimeField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  string $sort 排序方式 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  bool $updatable 查询有更新的订单 [ require false ]
     * @support  bool $todayTakeOrder 是否查询今日新接单 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 页码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function uploadList () {
        return self::getClass()->uploadList([
        ]);
    }

    /**
     * 标记退款中不需要处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $saleId 销售id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tabRefundNotDealWith () {
        return self::getClass()->tabRefundNotDealWith([
        ]);
    }

    /**
     * 标记订单无需处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tabOrderUpdateNotDealWith () {
        return self::getClass()->tabOrderUpdateNotDealWith([
        ]);
    }

    /**
     * 获取各上传总数
     *
     * @support  string $type 查询类型 [ require false ]
     * @support  string $searchTimeField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  bool $todayTakeOrder 是否查询今日新接单 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  bool $updatable 查询有更新的订单 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function variousUploadedTotal () {
        return self::getClass()->variousUploadedTotal([
        ]);
    }

    /**
     * 上传照片到云端
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function uploadPhotoCloud (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $cmd) {
        return self::getClass()->uploadPhotoCloud($cmd);
    }


    /**
     * 获取订单剩余可传张数
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $saleId saleId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderProductUploadedNum () {
        return self::getClass()->getOrderProductUploadedNum([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\UploadRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\UploadRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}