<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pushOrderToCameramanByParams(array $params)
 * @method revokeCloudStreamByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudExtraByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method revokeOrderByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method getTotalCountByParams(array $params)
 * @method getExtraHistoryListByParams(array $params)
 * @method revokeSubmitExtraByParams(array $params)
 * @method reSubmitExtraByParams(array $params)
 * @method getExtraPhotoDetailByParams(array $params)
 * @method remainingPhotoByParams(array $params)
 * @method excellencePhotoUploadSettingByParams(array $params)
 * @method shanghaiBlueStoreByParams(array $params)
 * @method getOrderCameramanInfoBaseAuthByParams(array $params)
 * @method getDresserNoteByOrderIdsByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单添加至摄影师
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pushOrderToCameraman () {
        return self::getClass()->pushOrderToCameraman([
        ]);
    }

    /**
     * 撤回照片(流水维度)
     *
     * @support  int $cloudStreamId 流水id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeCloudStream () {
        return self::getClass()->revokeCloudStream([
        ]);
    }

    /**
     * 云端流水详情
     *
     * @support  int $cloudStreamId 流水id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo () {
        return self::getClass()->getCloudStreamInfo([
        ]);
    }

    /**
     * 多余底片上传
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submitToCloudExtra () {
        return self::getClass()->submitToCloudExtra([
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo () {
        return self::getClass()->getHistoryInfo([
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList([
        ]);
    }

    /**
     * 撤回订单照片
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeOrder () {
        return self::getClass()->revokeOrder([
        ]);
    }

    /**
     * 批量获取流水详情
     *
     * @support  array $cloudStreamIds 流水ids [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds([
        ]);
    }

    /**
     * 获取赠送底片记录统计
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTotalCount () {
        return self::getClass()->getTotalCount([
        ]);
    }

    /**
     * 获取摄影师赠送底片上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExtraHistoryList () {
        return self::getClass()->getExtraHistoryList([
        ]);
    }

    /**
     * 撤回赠送底片上传
     *
     * @support  int $id 赠送底片记录Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeSubmitExtra () {
        return self::getClass()->revokeSubmitExtra([
        ]);
    }

    /**
     * 重新上传多余底片
     *
     * @support  int $id 历史记录id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reSubmitExtra () {
        return self::getClass()->reSubmitExtra([
        ]);
    }

    /**
     * 多余底片详情
     *
     * @support  int $id 历史记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExtraPhotoDetail () {
        return self::getClass()->getExtraPhotoDetail([
        ]);
    }

    /**
     * 获取剩余传输底片数量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function remainingPhoto () {
        return self::getClass()->remainingPhoto([
        ]);
    }

    /**
     * 当前门店是否需要上传优秀底片
     *
     * @throws  \Exception
     * @return  array
     */
    public static function excellencePhotoUploadSetting () {
        return self::getClass()->excellencePhotoUploadSetting();
    }

    /**
     * 判断是否为上海蓝标店
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function shanghaiBlueStore () {
        return self::getClass()->shanghaiBlueStore();
    }

    /**
     * 获取订单绑定的摄影师信息及权限
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderCameramanInfoBaseAuth () {
        return self::getClass()->getOrderCameramanInfoBaseAuth([
        ]);
    }

    /**
     * 批量获取订单化妆备注
     *
     * @support  array $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserNoteByOrderIds () {
        return self::getClass()->getDresserNoteByOrderIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}