<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $params)
 * @method hookCloudFinishStreamByParams(array $params)
 * @method hookCloudStreamStateChangedByParams(array $params)
 * @method hookStreamProblemTagPhotographyByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $params)
 * @method hookStreamProblemTagMakeupByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $params)
 * @method hookStreamPhotoMetaTagByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Controllers\StreamPhotoMetaTagCmd $params)
 * @method evaluateRetoucherByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $params)
 */
class CloudStream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询单条流水
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamDetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamDetailDTO"
        );
    }


    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishStream (string $stream_num) {
        return self::getClass()->hookCloudFinishStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 接收云端流水状态更新事件
     *
     * @support  string $stream_num 流水号 [ require false ]
     * @support  int $retoucher_id 修图师id [ require false ]
     * @support  string $state 云端流水接单状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudStreamStateChanged () {
        return self::getClass()->hookCloudStreamStateChanged([
        ]);
    }

    /**
     * hook流水－摄影问题标签
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookStreamProblemTagPhotography (\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $cmd) {
        return self::getClass()->hookStreamProblemTagPhotography($cmd);
    }


    /**
     * hook流水－化妆问题标签
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookStreamProblemTagMakeup (\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamProblemTagCmd $cmd) {
        return self::getClass()->hookStreamProblemTagMakeup($cmd);
    }


    /**
     * hook流水－图片七牛云标签
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Controllers\StreamPhotoMetaTagCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hookStreamPhotoMetaTag (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Controllers\StreamPhotoMetaTagCmd $cmd) {
        return self::getClass()->hookStreamPhotoMetaTag($cmd);
    }


    /**
     * 评价修图师风格
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function evaluateRetoucher (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\EvaluateRetoucherCmd $cmd) {
        return self::getClass()->evaluateRetoucher($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}