<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $params)
 * @method uploadListByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadListCmd $params)
 * @method uploadPhotoCloudByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $params)
 * @method bindOrderUploadByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $params)
 * @method revokeCloudStreamByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $params)
 * @method revokeOrderByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudExtraByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadCloudExtraCmd $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method getTotalCountByParams(array $params)
 * @method getExtraHistoryListByParams(array $params)
 * @method revokeSubmitExtraByParams(array $params)
 * @method reSubmitExtraByParams(array $params)
 * @method getExtraPhotoDetailByParams(array $params)
 * @method remainingPhotoByParams(array $params)
 * @method excellencePhotoUploadSettingByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师中心：搜索订单
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\SearchOrderDTO[]
     */
    public static function searchOrder (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\SearchOrderCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchOrder($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\SearchOrderDTO[]"
        );
    }


    /**
     * 摄影师中心订单列表
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\UploadListDTO[]
     */
    public static function uploadList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->uploadList($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Cameraman\UploadListDTO[]"
        );
    }


    /**
     * 上传照片到云端
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function uploadPhotoCloud (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadPhotoCmd $cmd) {
        return self::getClass()->uploadPhotoCloud($cmd);
    }


    /**
     * 订单添加至摄影师
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindOrderUpload (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $cmd) {
        return self::getClass()->bindOrderUpload($cmd);
    }


    /**
     * 撤回照片(流水维度)
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeCloudStream (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $cmd) {
        return self::getClass()->revokeCloudStream($cmd);
    }


    /**
     * 撤回订单照片
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeOrder (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $cmd) {
        return self::getClass()->revokeOrder($cmd);
    }


    /**
     * 云端流水详情
     *
     * @support  int $cloudStreamId 流水id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo () {
        return self::getClass()->getCloudStreamInfo([
        ]);
    }

    /**
     * 多余底片上传
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadCloudExtraCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitToCloudExtra (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\UploadCloudExtraCmd $cmd) {
        return self::getClass()->submitToCloudExtra($cmd);
    }


    /**
     * 获取订单历史上传记录详情
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo () {
        return self::getClass()->getHistoryInfo([
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList([
        ]);
    }

    /**
     * 批量获取流水详情
     *
     * @support  array $cloudStreamIds 流水ids [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds([
        ]);
    }

    /**
     * 获取赠送底片记录统计
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTotalCount () {
        return self::getClass()->getTotalCount([
        ]);
    }

    /**
     * 获取摄影师赠送底片上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExtraHistoryList () {
        return self::getClass()->getExtraHistoryList([
        ]);
    }

    /**
     * 撤回赠送底片上传
     *
     * @support  int $id 赠送底片记录Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeSubmitExtra () {
        return self::getClass()->revokeSubmitExtra([
        ]);
    }

    /**
     * 重新上传多余底片
     *
     * @support  int $id 历史记录id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reSubmitExtra () {
        return self::getClass()->reSubmitExtra([
        ]);
    }

    /**
     * 多余底片详情
     *
     * @support  int $id 历史记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExtraPhotoDetail () {
        return self::getClass()->getExtraPhotoDetail([
        ]);
    }

    /**
     * 获取剩余传输底片数量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function remainingPhoto () {
        return self::getClass()->remainingPhoto([
        ]);
    }

    /**
     * 当前门店是否需要上传优秀底片
     *
     * @throws  \Exception
     * @return  array
     */
    public static function excellencePhotoUploadSetting () {
        return self::getClass()->excellencePhotoUploadSetting();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}