<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindCheckerByParams(array $params)
 * @method getWaitReviewCountByParams(array $params)
 * @method getWaitReviewListByParams(array $params)
 * @method queryWaitFinishListByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getUnreadCountByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanNotifyByParams(array $params)
 * @method getPictureOnlineRetoucherByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method checkUnreadStreamByParams(array $params)
 */
class Review {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 绑定审核人id
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker([
        ]);
    }

    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReviewCount () {
        return self::getClass()->getWaitReviewCount();
    }

    /**
     * 待审核订单列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReviewList () {
        return self::getClass()->getWaitReviewList([
        ]);
    }

    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  string $wholeOrderNum 全国范围订单号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitFinishList () {
        return self::getClass()->queryWaitFinishList([
        ]);
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 提交审核
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  string $evaluate 评价 [ require false ]
     * @support  array $photo 照片 [ require false ]
     * @support  string $note 评语 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function review () {
        return self::getClass()->review([
        ]);
    }

    /**
     * 获取未读流水
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getUnreadCount () {
        return self::getClass()->getUnreadCount();
    }

    /**
     * 提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 清除未完成的订单列表提示
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanNotify () {
        return self::getClass()->cleanNotify();
    }

    /**
     * 获取在线看片师信息
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureOnlineRetoucher () {
        return self::getClass()->getPictureOnlineRetoucher([
        ]);
    }

    /**
     * 看片审核历史列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  bool $changedStore 是否为转门店数据 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory([
        ]);
    }

    /**
     * 发送看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify([
        ]);
    }

    /**
     * 查看未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUnreadStream () {
        return self::getClass()->checkUnreadStream();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Review');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Review');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}