<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $params)
 * @method cloudListByParams(array $params)
 */
class CloudStream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询单条流水
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamDetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Stream\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\StreamDetailDTO"
        );
    }


    /**
     * 获取云端订单下所有正常流水
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\CloudListDTO[]
     */
    public static function cloudList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cloudList([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Stream\CloudListDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\CloudStream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}