<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productRetouchStyleByParams(array $params)
 * @method cloudProductInfoByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Product\CloudProductListCmd $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取云端产品的修图风格
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\RetouchStyleResDTO[]
     */
    public static function productRetouchStyle (int $productId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productRetouchStyle([
                            "productId" => $productId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\RetouchStyleResDTO[]"
        );
    }

    /**
     * 获取云端产品信息
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Product\CloudProductListCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function cloudProductInfo (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Product\CloudProductListCmd $cmd) {
        return self::getClass()->cloudProductInfo($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}