<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method addPostNumByParams(array $params)
 * @method getPhotoSizeByIdsByParams(array $params)
 */
class PictureOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 在线看片设置打印
     *
     * @support  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPrint () {
        return self::getClass()->setPrint([
        ]);
    }

    /**
     * 在线看片详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 修改取片方式
     *
     * @support  string $recordNo 看片单号 [ require true ]
     * @support  string $takeType 取片方式 [ require true ]
     * @support  mixed $postInfo 取片信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeTakePhotoType () {
        return self::getClass()->changeTakePhotoType([
        ]);
    }

    /**
     * 标记发件
     *
     * @support  string $recordNo 看片单号 [ require true ]
     * @support  string $postNum 邮递单号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addPostNum () {
        return self::getClass()->addPostNum([
        ]);
    }

    /**
     * 根据看片单ids获取打印尺寸
     *
     * @support  array $ids 看片单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoSizeByIds () {
        return self::getClass()->getPhotoSizeByIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\PictureOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\PictureOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}