<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queueToWaitingByParams(array $params)
 * @method dailyCleanByParams(array $params)
 * @method removeStaffHangByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天9-23点每分钟执行-签到排队状态自动进入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueToWaiting () {
        return self::getClass()->queueToWaiting();
    }

    /**
     * 每天4点执行-清空前一日流程记录
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function dailyClean () {
        return self::getClass()->dailyClean([
        ]);
    }

    /**
     * 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHang () {
        return self::getClass()->removeStaffHang();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}