<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthsByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method beginWorkByParams(array $params)
 * @method endWorkByParams(array $params)
 * @method hangByParams(array $params)
 * @method cancelHangByParams(array $params)
 * @method getTodayWorkDetailsByParams(array $params)
 * @method getStaffOrdersByParams(array $params)
 * @method getTodayOrdersByParams(array $params)
 * @method getStaffStatusByParams(array $params)
 */
class StaffDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴身份列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuths () {
        return self::getClass()->getAuths();
    }

    /**
     * 选择进入的身份类型
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $staffType 摄影师: sys,化妆师: hzs [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function chooseType () {
        return self::getClass()->chooseType([
        ]);
    }

    /**
     * 获取伙伴信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 开始工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function beginWork () {
        return self::getClass()->beginWork();
    }

    /**
     * 结束工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function endWork () {
        return self::getClass()->endWork();
    }

    /**
     * 挂起
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hang () {
        return self::getClass()->hang();
    }

    /**
     * 取消挂起
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelHang () {
        return self::getClass()->cancelHang();
    }

    /**
     * 获取今日工作明细
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayWorkDetails () {
        return self::getClass()->getTodayWorkDetails();
    }

    /**
     * 获取工作台订单
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffOrders () {
        return self::getClass()->getStaffOrders();
    }

    /**
     * 获取今日化妆单
     *
     * @support  string $status 状态，working：未完成，completed：已完成 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayOrders () {
        return self::getClass()->getTodayOrders([
        ]);
    }

    /**
     * 获取伙伴的状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffStatus () {
        return self::getClass()->getStaffStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\StaffDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\StaffDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}