<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reworkStreamByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method backWaitLookingByParams(array $params)
 * @method clearAutoFinishPhotoByParams(array $params)
 * @method kpsOrderAgainByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method getLookingPhotoExtendInfoByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片退单
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function reworkStream () {
        return self::getClass()->reworkStream([
        ]);
    }

    /**
     * 看片师已接订单
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnline () {
        return self::getClass()->getOrderOnline();
    }

    /**
     * 订单详情
     *
     * @support  bool $withRetake 是否显示删除的流水信息 [ require false ]
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail([
        ]);
    }

    /**
     * 订单退回等待看片
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLooking (int $orderId) {
        return self::getClass()->backWaitLooking([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 清除自动看片完成订单的顾客满意片
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAutoFinishPhoto (int $orderId) {
        return self::getClass()->clearAutoFinishPhoto([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 看片师再来一单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function kpsOrderAgain () {
        return self::getClass()->kpsOrderAgain();
    }

    /**
     * 提交最终成片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitFinalPhoto (string $streamNum, array $photoData) {
        return self::getClass()->submitFinalPhoto([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice([
        ]);
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  bool $changedStore 是否为转门店数据 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList([
        ]);
    }

    /**
     * 获取看片照片数量,时长,看片通知时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLookingPhotoExtendInfo (int $orderId) {
        return self::getClass()->getLookingPhotoExtendInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}